function [report] = udpquery(startip,iprange)
%[report] = udpquery(startip,iprange)
% Query udp ips for presence of peekpoke processor
% r = udpquery("192.168.1.0",1:10)
% r= udpquery("192.168.1.10",0:25)
% r= udpquery("192.168.1.10",0:1000)
% 17 July 2020 - Ian Stothers
% 23 Mar 2022 - Ian Stothers
if (nargin<1)
 startip =  "192.168.1.0";
 iprange = 0:20;
end
idx=1;
report=char([]);
sipnum=ip2num(startip);
for iplsb=iprange
 ip=num2ip(sipnum+iplsb);
 rep=udpsktquery(ip);
 if (rep>0)
  r=[ip "           "](1:15);
  r=[r sprintf("%dbit",rep)];
  report=[report r'];
 end
endfor
report=report';
endfunction

function [ip] = num2ip(num)
%function [ip] = num2ip(num)
% Convert num to text ip port adress
%a= ip2num(522546574)
%
% 17 July 2020 - Ian Stothers
for d=3:-1:0
hd(d+1)=floor(num/(256^d));
num=num-((256^d)*hd(d+1));
end
ip=sprintf("%d.%d.%d.%d",hd(4),hd(3),hd(2),hd(1));
endfunction

function [num] = ip2num(remoteip)
%function [num] = ip2num(remoteip)
% Convert text ip port adress to num
%a= ip2num(192.168.1.5)
%
% 17 July 2020 - Ian Stothers
a=remoteip;
a=a(find((a+0)!=32)); %remove spaces
idx=find(a==".");
if (prod(size(idx))!=3)
  error(" Format for IP is 192.168.1.5 ");
end
num=sscanf(a,"%d.%d.%d.%d");
num=(256.^(3:-1:0))*num;
endfunction

function [bits] = udpsktquery(remoteip);
%[skt] = udpsktquery(remoteip);
% See udpquery.m for ip range query
% Query specific udp ip for presence of peekpoke processor
% 17 July 2020 - Ian Stothers
% modified 19 Jan 2021 - fix error message

if((exist('udp')~=3))
    pkg load instrument-control; % load the instrument control octave library
end
if (exist('udp')~=3)
  error('Needs instrument-control toolbox');
  return
end
bits=0;
if (nargin==1)
 skt.ip = remoteip;
 minport=30000; % search socket range
 maxport=32000;
 socket=minport;
 gotone=0;
 while (gotone==0)
   try
    skt.udp  = udpport('localport',socket);
    skt.udp.Timeout=0.02;
    gotone=1;
   catch
    socket=socket+1
    if (socket>maxport)
      error('no socket found');
    end
   end % catch
  end %while

b32_infosize=16;
b16_infosize=10;
pbuf=uint8([1 0 0 0]);

b=[];
ok=0;

try
      flushinput(skt.udp);
      write(skt.udp,pbuf,skt.ip,skt.udp.LocalPort);
      flushoutput(skt.udp);
      b=double(read(skt.udp,b32_infosize));
 if (max(size(b))==b16_infosize)
     bits=16;
 end
 if (max(size(b))==b32_infosize)
     bits=32;
 end
catch
end
 sktclose(skt.udp);
else
  error('udpsktquery needs 1 argument - type help udpsktquery for details');
end  %if
endfunction

